﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="2.0" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">

<html>
	<head>
		<title>724 Web service</title>
		<style>
		html, body {
	margin: 0;
	padding: 0;
}
.header {
	z-index: 1;
	margin-top:-20px;
	position:relative;
	color:white;
	top:0px;
	text-align:center;
	background-color: #dd0000; 
}
.main {
	color:white;
	max-width:960px;
	margin:auto;
	position:relative;
}
.footer {
	z-index: 1;
	position:fixed;
	color:white;
	margin:auto;
	bottom:0px;
	left:0px;
	right:0px;
	text-align:center;
	background-color: #111111; 
}
.nav{
	z-index: 1;
	float:left;
	border:solid 1px;
	top:10px;
	left:120px;
	bottom:10px;
	right:10px;
	margin:10px;
	padding:10px;
}
.messagesucceed {
	position:relative;
	margin:10px;
	padding:10px;
}
body {
	color:white;
	background-color: #444444; 
	font-family: Verdana, sans-serif; 
	font-size: 100%;
}
h1 {
 font-size: 200%; 
 color: white; 
 text-align: center;
 }
h2 {
 font-size: 150%; 
 color: white; 
 padding-left: 15px;
 text-align: center;
 }
p,ul,li,td, header, footer {
	color: white; 
	text-align: justify;
	text-justify: inter-word;
}
a:link {
 color: green;
 text-decoration: underline;
 }
a:visited {
 color: gray;
 }
a:hover {
 color: red;
 text-decoration: none;
}
a:active, a:focus {
 color: red;
}
.errortext {
	color:red;
	font-size: 200%; 
	text-align: center;
}
.messagetext {
	font-size: 150%; 
	text-align: center;
}
.formlabel {
	width:100px;
}
		</style>
	</head>
	<body>
		<div class="header"><h1>Seven24 Web service - Liste des utilisateurs</h1></div>
		
                <div><p><b><xsl:value-of select="/DOCUMENT/USERS/@COUNT"/> adhérents, mise à jour: <xsl:value-of select="/DOCUMENT/USERS/@LASTUPDATE"/></b></p><p>
			<table class="sessions" >
				<thead>
					<tr>
						<th>N° dossier</th>
						<th>Nom/Prénom</th>
						<th>Autorisation</th>
						<th>Timezone</th>
					</tr>
				</thead>
				<tbody>
                                        <xsl:for-each select="/DOCUMENT/USERS/USER" >
						<tr>
							<td><xsl:value-of select="./@id"/></td>
							<td><xsl:value-of select="./@firstname"/><xsl:text> </xsl:text><xsl:value-of select="./@lastname"/></td>
							<td>
								<xsl:choose>
									<xsl:when test="./@authorized='true'">
										<xsl:text>OUI</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text>NON</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td><xsl:value-of select="./@timezone"/></td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table></p>
		</div>
		
		<div class="footer"> ©Bodin Jean-Christophe - Tous droits réservés 2016. </div> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
